IF EXISTS ( SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO')
BEGIN 
	DROP TRIGGER TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO 
'Objetivo............: Tratamento para nao alteracao do Funcionario Anonimizado
'Tabelas.............: 
'Dt Criao..........: 23/09/2021
'Dt Ult Alteraco....: 30/07/2021
'Alterado por........: Marcos Barros 
'Criado por..........: Marcos Barros 
'=======================================================================================
*/
END
GO
CREATE TRIGGER TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO ON FP_FUNC FOR UPDATE AS
	DECLARE @CD_FUN INT
	 IF UPDATE (UUID)
	BEGIN
		RETURN;
	END
	SET @CD_FUN = ISNULL((SELECT TOP 1 CD_FUN FROM inserted),0);

	IF EXISTS (SELECT 
					1 
			   FROM 
					LGPD_LOG_PROCESSAMENTO 
				WHERE
					CD_PESSOA = @CD_FUN
					AND TP_PROC = 3)
	  begin
		RAISERROR ('ALTERACAO NO PERMITIDA, CADASTRO ANONIMIZADO!',16, 1);
		ROLLBACK TRANSACTION;
		RETURN;
	  end

GO

ALTER TABLE FP_FUNC ENABLE TRIGGER TRG_FP_FUNC_BLOQUEIA_FUNC_ANONIMIZADO

